package com.rapidminer.krimp.gui;

import javax.swing.table.AbstractTableModel;

import com.rapidminer.krimp.CodeTable;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.tools.Tools;

public class STCodeTableModel extends AbstractTableModel {

	private static final long serialVersionUID = 5490209607479134881L;
	private static final int COLUMN_SUPPORT = 0;
	private static final int COLUMN_CODE_LENGTH = 1;
	private final FrequentItemSet[] codingSet;
	private final double[] codeLength;
	private int nrOfColumns;

	public STCodeTableModel(CodeTable codeTable) {
		codingSet = codeTable.getItemSets().toArray(new FrequentItemSet[0]);
		codeLength = new double[codingSet.length];
		nrOfColumns = 0;
		int i = 0;
		for (FrequentItemSet itemSet : codeTable.getItemSets()) {
			nrOfColumns = Math.max(nrOfColumns, itemSet.getNumberOfItems());
			codeLength[i++] = codeTable.getCodeLengthRight(itemSet);
		}
		nrOfColumns += 2;
	}

	@Override
	public String getColumnName(int column) {
		if (column == COLUMN_SUPPORT) {
			return "Support";
		} else if (column == COLUMN_CODE_LENGTH) {
			return "Standard Code Length";
		} else {
			return "Item";
		}
	}

	@Override
	public int getRowCount() {
		return codingSet.length;
	}

	@Override
	public int getColumnCount() {
		return nrOfColumns;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (columnIndex == COLUMN_SUPPORT) {
			return codingSet[rowIndex].getFrequency();
		} else if (columnIndex == COLUMN_CODE_LENGTH) {
			return Tools.formatNumber(codeLength[rowIndex]);
		} else {
			int actualIndex = columnIndex - 2;
			if (actualIndex < codingSet[rowIndex].getNumberOfItems()) {
				return codingSet[rowIndex].getItem(actualIndex).toString();
			} else {
				return "";
			}
		}
	}

}
